function fault_slip_plot_snapshots(...
    a,b,colors,~,~,~,~,~,~,~,~,~,~,...
    ddelta_ds_01,ddelta_ds_02,ddelta_ds_03,ddelta_ds_04,ddelta_ds_05,... 
    delta_01,delta_02,delta_03,delta_04,delta_05,...
    flag_fric,~,flag_plot_cap,...
    ~,sigma_breve_02,~,~,~,...
    sigma_C_01,sigma_C_02,sigma_C_03,sigma_C_04,sigma_C_05,...
    sigma_C_post_01,sigma_C_post_02,sigma_C_post_03,sigma_C_post_04,sigma_C_post_05,...
    ~,sigma_shear_comb_02,~,~,~,...
    ~,sigma_slip_02,~,~,~,...
    theta,...
    y_breve_01,y_breve_02,y_breve_03,y_breve_04,y_breve_05,...
    y_delta_01,y_delta_02,y_delta_03,y_delta_04,y_delta_05,...
    ~,y_inter_02,~,~,~,...
    y_plot_max_delta_1,y_plot_min_delta_1,...
    y_plot_max_delta_2,y_plot_min_delta_2,...
    y_plot_max_sigma,y_plot_min_sigma,...
    y_sigma_01,y_sigma_02,y_sigma_03,y_sigma_04,y_sigma_05,...
    y_tilde_01,y_tilde_02,y_tilde_03,y_tilde_04,y_tilde_05) 
%
% Plots stresses and slip at the fault at pre-selected depletion pressures.
%
% Retrieve colors:
blue = colors(1,:);
gray = colors(2,:);
green = colors(3,:);
orange = colors(4,:);

if flag_fric == 1
    figure % Shear stresses and slip threshold (left) and Coulomb stresses (right)
    subplot(1,2,1)
    % Plot patches representing fault blocks:
    f_stretch = 3; % stretch factor for plotting of fault blocks
    x_patch_left = [-2.9 -2.9 ((b-a)/tan(theta)/f_stretch) 0];
    y_patch_left = [-150 75 75 -150];
    patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
    hold on
    x_patch_right = [24-((b-a)/tan(theta)/f_stretch) 24 26.9 26.9];
    y_patch_right = [-75 150 150 -75];
    patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
    % Plot colored patches between sigma_slip and sigma_shear_comb:
    n_seg = 25; % number of segments
    y_seg = linspace(y_inter_02(1),y_inter_02(2),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = interp1(y_sigma_02,sigma_slip_02,y_seg_bot');
    x_seg_2 = interp1(y_sigma_02,sigma_slip_02,y_seg_top');
    x_seg_3 = interp1(y_sigma_02,sigma_shear_comb_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_shear_comb_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    y_seg = linspace(y_inter_02(3),y_inter_02(4),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = interp1(y_sigma_02,sigma_slip_02,y_seg_bot');
    x_seg_2 = interp1(y_sigma_02,sigma_slip_02,y_seg_top');
    x_seg_3 = interp1(y_sigma_02,sigma_shear_comb_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_shear_comb_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    %
    x_min =   -3;
    x_max =   27;
    y_min = y_plot_min_sigma;
    y_max = y_plot_max_sigma;
    line([x_min x_max],[y_inter_02(4) y_inter_02(4)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(3) y_inter_02(3)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(2) y_inter_02(2)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(1) y_inter_02(1)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
%     line([0 15],[150 150],'LineStyle','-','Color','k','LineWidth',1.5) % cosmetic correction
%     line([0 18],[-150 -150],'LineStyle','-','Color','k','LineWidth',1.5) % cosmetic correction
    plot(sigma_slip_02/1e6,y_sigma_02,'-','LineWidth',1.5,'Color','k') % right slip threshold; only fault
    % in reservoir "sees" incremental pressure
    % % % plot(sigma_slip_full/1e6,y_sigma_02,'--','LineWidth',1.5,'Color','k') % right slip threshold; full
    % % % % fault "sees" incremental pressure
    plot(sigma_shear_comb_02/1e6,y_sigma_02,'r','LineWidth',1.5) % shear stresses
    hold off
    xlabel('$\rm \Sigma_{\parallel}$ and $\Sigma_{sl}$ (MPa)','Interpreter','latex',...
        'FontSize',11)
    ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    text(27.5,y_inter_02(1),'$\it y_1$','Interpreter','latex','FontSize',11)
    text(27.5,y_inter_02(2),'$\it y_2$','Interpreter','latex','FontSize',11)
    text(27.5,y_inter_02(3),'$\it y_3$','Interpreter','latex','FontSize',11)
    text(27.5,y_inter_02(4),'$\it y_4$','Interpreter','latex','FontSize',11)
    box on
    
    subplot(1,2,2)
    hold on
    x_patch_left = [-21.9 -21.9 -19+((b-a)/tan(theta)/f_stretch) -19];
    patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
    x_patch_right = [5-((b-a)/tan(theta)/f_stretch) 5 7.9 7.9];
    patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
    % Plot colored patches between x = 0 and sigma_C:
    y_seg = linspace(y_inter_02(1),y_inter_02(2),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    y_seg = linspace(y_inter_02(3),y_inter_02(4),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    %
    line([-2 -2],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([-2  6],[-100 -100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([-2  6],[ 100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([ 6  6],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    x_min = -22;
    x_max = 8;
    line([x_min x_max],[y_inter_02(4) y_inter_02(4)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(3) y_inter_02(3)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(2) y_inter_02(2)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(1) y_inter_02(1)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(sigma_C_02/1e6,y_sigma_02,'-r','LineWidth',1.5)
%     line([8 15],[75 75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
%     line([8 15],[-75 -75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
    hold off
    xlabel('$\Sigma_C$ (MPa) ','Interpreter','latex','FontSize',11)
    % % % ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    text(8.5,y_inter_02(1),'$\it y_1$','Interpreter','latex','FontSize',11)
    text(8.5,y_inter_02(2),'$\it y_2$','Interpreter','latex','FontSize',11)
    text(8.5,y_inter_02(3),'$\it y_3$','Interpreter','latex','FontSize',11)
    text(8.5,y_inter_02(4),'$\it y_4$','Interpreter','latex','FontSize',11)
    box on
    
    figure % Stresses (left) and slip (right) for a single depletion pressure
    subplot(1,2,1)
    x_patch_left = [-14.9 -14.9 -12+((b-a)/tan(theta)/f_stretch) -12];
    patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
    hold on
    x_patch_right = [12-((b-a)/tan(theta)/f_stretch) 12 14.9 14.9];
    patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
    % Plot colored patches between x = 0 and sigma_C:
    y_seg = linspace(y_inter_02(1),y_inter_02(2),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    y_seg = linspace(y_inter_02(3),y_inter_02(4),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    %
    line([-2 -2],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([-2  6],[-100 -100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([-2  6],[ 100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([ 6  6],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    x_min = -15;
    x_max = 15;
    line([x_min x_max],[y_inter_02(4) y_inter_02(4)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(3) y_inter_02(3)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(2) y_inter_02(2)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(1) y_inter_02(1)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(2) y_tilde_02(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(1) y_tilde_02(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(sigma_C_02/1e6,y_sigma_02,'-r','LineWidth',1.5)
%     line([8 15],[75 75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
%     line([8 15],[-75 -75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
    plot(-sigma_breve_02/1e6,y_breve_02,'Color',orange,'LineStyle','-','LineWidth',1.5)
    y_breve_02(1:end-1) = y_breve_02(1:end-1) + (y_breve_02(2:end) == y_breve_02(1:end-1)) * 10* eps;
    % perturbs repeated y values
    y_post_slip = linspace(-250,250,100); % determines number of blue dots
    sigma_C_post_slip = ...
        interp1(y_sigma_02,sigma_C_02,y_post_slip) - interp1(y_breve_02,sigma_breve_02,y_post_slip);
    plot(sigma_C_post_slip/1e6,y_post_slip,'o','MarkerSize',3,...
        'MarkerEdgeColor',blue,'MarkerFaceColor',blue)
    hold off
    xlabel('$\Sigma_C$ and $\rm \breve{\sigma}_{\parallel}$ (MPa) ','Interpreter','latex',...
        'FontSize',11)
    ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    % axis([-6 6 -100 100])
    text(15.5,y_inter_02(1),'$\it y_1$','Interpreter','latex','FontSize',11)
    text(15.5,y_inter_02(2),'$\it y_2$','Interpreter','latex','FontSize',11)
    text(15.5,y_inter_02(3),'$\it y_3$','Interpreter','latex','FontSize',11)
    text(15.5,y_inter_02(4),'$\it y_4$','Interpreter','latex','FontSize',11)
    box on
    
    subplot(1,2,2)
    %x_patch_left = [-14.9 -14.9 -12+((b-a)/tan(theta)/f_stretch) -12];
    x_patch_left = [-2.45e-3 -2.45e-3 (-1+((b-a)/tan(theta)/(2*f_stretch)))*1e-3 -1e-3];
    patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
    hold on
    %x_patch_right = [12-((b-a)/tan(theta)/f_stretch) 12 14.9 14.9];
    x_patch_right = [(11-((b-a)/tan(theta)/(2*f_stretch)))*1e-3 11e-3 12.45e-3 12.45e-3];
    patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
    x_min = -2.5e-3;
    x_max = 12.5e-3;
    % line([-2 -2],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    % line([-2  6],[-100 -100],'LineStyle','-.','Color','k','LineWidth',0.5)
    % line([-2  6],[ 100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    % line([ 6  6],[-100  100],'LineStyle','-.','Color','k','LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(2) y_tilde_02(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(1) y_tilde_02(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(delta_02,y_delta_02,'-','LineWidth',1.5,'Color','r')
    line([0 0],[y_min -100],'LineStyle','-','Color','r','LineWidth',1.5)
    line([0 0],[100, y_max],'LineStyle','-','Color','r','LineWidth',1.5)
    hold off
    xlabel('$\delta$ (m)','Interpreter','latex','FontSize',11)
    % % % ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    text(12.75e-3,y_tilde_02(1),'$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
    text(12.75e-3,y_tilde_02(2),'$\it \tilde{y}_2$','Interpreter','latex','FontSize',11)
    text(12.75e-3,y_tilde_02(3),'$\it \tilde{y}_3$','Interpreter','latex','FontSize',11)
    text(12.75e-3,y_tilde_02(4),'$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
    box on
    
    figure % Stresses (left) and slip (right) for multiple depletion pressures   
    subplot(1,2,1)
    hold on
    x_min = -2;
    x_max = 6;
    y_min = y_plot_min_delta_1;
    y_max = y_plot_max_delta_1;
    % Plot colored patches between x = 0 and sigma_C:
    n_seg = 25; % number of segments
    y_seg = linspace(y_inter_02(1),y_inter_02(2),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    y_seg = linspace(y_inter_02(3),y_inter_02(4),n_seg);
    y_seg_bot = y_seg(1:end-1);
    y_seg_top = y_seg(2:end);
    y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
    x_seg_1 = zeros(n_seg-1,1);
    x_seg_2 = zeros(n_seg-1,1);
    x_seg_3 = interp1(y_sigma_02,sigma_C_02,y_seg_top');
    x_seg_4 = interp1(y_sigma_02,sigma_C_02,y_seg_bot');
    x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
    patch(x_patch',y_patch',green,'LineStyle','none')
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    line([x_min x_max],[y_inter_02(4) y_inter_02(4)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(3) y_inter_02(3)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(2) y_inter_02(2)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_inter_02(1) y_inter_02(1)],'LineStyle','-','Color',green,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(2) y_tilde_02(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(1) y_tilde_02(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    plot(sigma_C_01/1e6,y_sigma_01,'k','LineWidth',1.5) % Coulomb stresses
    plot(sigma_C_02/1e6,y_sigma_02,'r','LineWidth',1.5)
    plot(-sigma_breve_02/1e6,y_breve_02,'Color',orange,'LineStyle','-','LineWidth',1.5)
    sigma_C_post_slip = ...
        interp1(y_sigma_02,sigma_C_02,y_post_slip) - interp1(y_breve_02,sigma_breve_02,y_post_slip);
    plot(sigma_C_post_slip/1e6,y_post_slip,'o','MarkerSize',3,...
        'MarkerEdgeColor',blue,'MarkerFaceColor',blue)
    plot(sigma_C_03/1e6,y_sigma_03,'k','LineWidth',1.5)
    plot(sigma_C_04/1e6,y_sigma_04,'k','LineWidth',1.5)
    plot(sigma_C_05/1e6,y_sigma_05,'k','LineWidth',1.5)
    plot(sigma_C_02/1e6,y_sigma_02,'r','LineWidth',1.5) % repeated to bring on top
    hold off
    
    text(6.25,y_inter_02(1)+1,'$\it y_1$','Interpreter','latex','FontSize',11)
    text(6.25,y_inter_02(2),'$\it y_2$','Interpreter','latex','FontSize',11)
    text(6.25,y_inter_02(3),'$\it y_3$','Interpreter','latex','FontSize',11)
    text(6.25,y_inter_02(4)-1,'$\it y_4$','Interpreter','latex','FontSize',11)
    text(6.25,y_tilde_02(1)-3,'$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
    text(6.25,y_tilde_02(2),'$\it \tilde{y}_2$','Interpreter','latex','FontSize',11)
    text(6.25,y_tilde_02(3),'$\it \tilde{y}_3$','Interpreter','latex','FontSize',11)
    text(6.25,y_tilde_02(4)+3,'$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
    
    xlabel('$\Sigma_C$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
%     text(-1.9,33.5,'$-24$','Interpreter','latex','FontSize',10)
%     text(-1.7,41.5,'$-25$','Color','red','Interpreter','latex','FontSize',10)
%     text(1.1,50.5,'$-26$','Interpreter','latex','FontSize',10)
%     text(2.2,57.5,'$-27$','Interpreter','latex','FontSize',10)
%     text(3.55,64.5,'$-28$ MPa','Interpreter','latex','FontSize',10)
    text(-1.7,41.5,'$-24$','Interpreter','latex','FontSize',10)
    text(1.1,50.5,'$-28$ MPa','Interpreter','latex','FontSize',10)
    
    box on
    
    subplot(1,2,2)
    hold on
    x_min = -2e-3;
    x_max = 18e-3;
    y_min = y_plot_min_delta_1;
    y_max = y_plot_max_delta_1;
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(2) y_tilde_02(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_02(1) y_tilde_02(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    plot(delta_01,y_delta_01,'-','LineWidth',1.5,'Color','k')
    plot(delta_02,y_delta_02,'-','LineWidth',1.5,'Color','r')
    plot(delta_03,y_delta_03,'-','LineWidth',1.5,'Color','k')
    plot(delta_04,y_delta_04,'-','LineWidth',1.5,'Color','k')
    plot(delta_05,y_delta_05,'-','LineWidth',1.5,'Color','k')
    plot(delta_02,y_delta_02,'-','LineWidth',1.5,'Color','r') % repeated to bring on top
    hold off
    xlabel('$\delta$ (m)','Interpreter','latex','FontSize',11)
    % % % ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    text(18.5e-3,y_tilde_02(1),'$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
    text(18.5e-3,y_tilde_02(2),'$\it \tilde{y}_2$','Interpreter','latex','FontSize',11)
    text(18.5e-3,y_tilde_02(3),'$\it \tilde{y}_3$','Interpreter','latex','FontSize',11)
    text(18.5e-3,y_tilde_02(4),'$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
    
    text(0.0001,56,'$-24$','Interpreter','latex','FontSize',10)
    x_patch_left = [0.001 0.001 0.0025 0.0025];
    y_patch_left = [38 45 45 38];
    color = 'white';
    patch(x_patch_left,y_patch_left,color,'LineStyle','none')
    text(0.0003,41,'$-25$','Color','red','Interpreter','latex','FontSize',10)
    x_patch_left = [0.0012 0.0012 0.0032 0.0032];
    y_patch_left = [29 36 36 29];
    patch(x_patch_left,y_patch_left,color,'LineStyle','none')
    text(0.0011,32,'$-26$','Interpreter','latex','FontSize',10)
    text(0.0035,24,'$-27$','Interpreter','latex','FontSize',10)
    text(0.008,20,'$-28$ MPa ','Interpreter','latex','FontSize',10)
    box on
end

if flag_fric == 2   
    figure % Pre-slip and post-slip Coulomb stresses (left), slip gradient (mid) and slip ...
        % (right) for multiple depletion pressures
    subplot(1,3,1)
    hold on
%     help_03 = [sigma_C_01 sigma_C_02 sigma_C_03 sigma_C_04 sigma_C_05];
%     x_min = min(help_03)/1e6;
%     x_max = max(help_03)/1e6;
    x_min = -3;
    x_max =  6;
    y_min = max(0,y_plot_min_delta_2);
    y_max = y_plot_max_delta_2;
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[y_tilde_01(3) y_tilde_01(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%    line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(3) y_tilde_03(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(3) y_tilde_04(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(3) y_tilde_05(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_01(4) y_tilde_01(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(4) y_tilde_03(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(4) y_tilde_04(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(4) y_tilde_05(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(sigma_C_01/1e6,y_sigma_01,'r','LineWidth',1.5) % Coulomb stresses
%     plot(sigma_C_02/1e6,y_sigma_02,'r','LineWidth',1.5)
    plot(sigma_C_03/1e6,y_sigma_03,'r','LineWidth',1.5)
    plot(sigma_C_04/1e6,y_sigma_04,'r','LineWidth',1.5)
    plot(sigma_C_05/1e6,y_sigma_05,'r','LineWidth',1.5)
    plot(sigma_C_post_01/1e6,y_breve_01,'LineStyle',':','Color',blue,'LineWidth',1.5)
%     plot(sigma_C_post_02/1e6,y_breve_02,'LineStyle',':','Color',blue,'LineWidth',1.5)
    plot(sigma_C_post_03/1e6,y_breve_03,'LineStyle',':','Color',blue,'LineWidth',1.5)
    plot(sigma_C_post_04/1e6,y_breve_04,'LineStyle',':','Color',blue,'LineWidth',1.5)
    plot(sigma_C_post_05/1e6,y_breve_05,'LineStyle',':','Color',blue,'LineWidth',1.5)
    hold off
%     text(-0.4/1e3,65.94-0.5,'$-17$','Interpreter','latex','FontSize',10)
%     text(-0.4/1e3,69.03-0.5,'$-16$','Interpreter','latex','FontSize',10)
%     text(-0.4/1e3,71.01-0.5,'$-15$','Interpreter','latex','FontSize',10)
%     text(-0.4/1e3,72.42-0.5,'$-14$','Interpreter','latex','FontSize',10)
%     text(-0.4/1e3,73.44-0.49,'$-13$','Interpreter','latex','FontSize',10)
    xlabel('${\Sigma_{\it C}}$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    if flag_plot_cap == 1
        [t,s] = title('plot\_snapshots','Coulomb stresses'); % first line: plot file locator
        t.Color = 'r';
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
    end
    box on

    subplot(1,3,2)
    hold on
    x_min = -2.0;
    x_max =  0.6;
    y_min = max(0,y_plot_min_delta_2);
    y_max = y_plot_max_delta_2;
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[y_tilde_01(3) y_tilde_01(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(3) y_tilde_03(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(3) y_tilde_04(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(3) y_tilde_05(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_01(4) y_tilde_01(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(4) y_tilde_03(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(4) y_tilde_04(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(4) y_tilde_05(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(ddelta_ds_01*1e3,y_delta_01,'-','LineWidth',1.5,'Color','r')
%     plot(ddelta_ds_02*1e3,y_delta_02,'-','LineWidth',1.5,'Color','r')
    plot(ddelta_ds_03*1e3,y_delta_03,'-','LineWidth',1.5,'Color','r')
    plot(ddelta_ds_04*1e3,y_delta_04,'-','LineWidth',1.5,'Color','r')
    plot(ddelta_ds_05*1e3,y_delta_05,'-','LineWidth',1.5,'Color','r')
    hold off
%     text(-0.4,65.94-0.5,'$-17$','Interpreter','latex','FontSize',10)
%     text(-0.4,69.03-0.5,'$-16$','Interpreter','latex','FontSize',10)
%     text(-0.4,71.01-0.5,'$-15$','Interpreter','latex','FontSize',10)
%     text(-0.4,72.42-0.5,'$-14$','Interpreter','latex','FontSize',10)
%     text(-0.4,73.44-0.49,'$-13$','Interpreter','latex','FontSize',10)
    xlabel('$\nabla{\it\delta}$ (mm/m)','Interpreter','latex','FontSize',11)
    ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    if flag_plot_cap
        [t,s] = title('','Slip gradient'); % first line: plot file locator
        t.Color = 'r';
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
    end
    box on
    
    subplot(1,3,3)
    hold on
%     help_04 = [delta_01 delta_02 delta_03 delta_04 delta_05];
%     x_min = min(help_04);
%     x_max = max(help_04);
    x_min = 0;
    x_max = 3.5;
    y_min = max(0,y_plot_min_delta_2);
    y_max = y_plot_max_delta_2;
    line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
    line([x_min x_max],[y_tilde_01(3) y_tilde_01(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_min x_max],[y_tilde_02(3) y_tilde_02(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(3) y_tilde_03(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(3) y_tilde_04(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(3) y_tilde_05(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_01(4) y_tilde_01(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_min x_max],[y_tilde_02(4) y_tilde_02(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_03(4) y_tilde_03(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_04(4) y_tilde_04(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([x_min x_max],[y_tilde_05(4) y_tilde_05(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
    line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
    plot(delta_01*1e3,y_delta_01,'-','LineWidth',1.5,'Color','r')
%     plot(delta_02*1e3,y_delta_02,'-','LineWidth',1.5,'Color','r')
    plot(delta_03*1e3,y_delta_03,'-','LineWidth',1.5,'Color','r')
    plot(delta_04*1e3,y_delta_04,'-','LineWidth',1.5,'Color','r')
    plot(delta_05*1e3,y_delta_05,'-','LineWidth',1.5,'Color','r')
    hold off
%     text(0.14,71.8,'$-15$','Interpreter','latex','FontSize',10)
%     text(0.67,71.8,'$-16$','Interpreter','latex','FontSize',10)
%     text(1.69,71.8,'$-17$','Interpreter','latex','FontSize',10)
    xlabel('$\delta$ (mm)','Interpreter','latex','FontSize',11)
    axis([x_min x_max y_min y_max])
    if flag_plot_cap == 1
        title('Slip','FontSize',10,'FontWeight','normal');
    end
    box on
    
end